<?php
session_start();

$servername = "localhost"; 
$username = "s2300379_g5pharmaease";
$password = "12345";
$dbname = "s2300379_g5pharmaease";

// Default empty user array
$user = [
    'first_name' => '',
    'last_name' => '',
    'phone' => '',
    'email' => '',
    'address' => '',
    'city' => ''
];

// Check if user is logged in
if (isset($_SESSION['user_email'])) {
    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    $email = $_SESSION['user_email'];

    // Adjust fields as per your database
    $sql = "SELECT name, email, phone FROM user_records WHERE email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->bind_result($name, $email, $phone);
	

    if ($stmt->fetch()) {
        // Optionally split name if needed
        $parts = explode(" ", $name, 2);
        $user['first_name'] = $parts[0];
        $user['last_name'] = isset($parts[1]) ? $parts[1] : '';
        $user['email'] = $email;
        $user['phone'] = $phone;
    }

    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PharmaEase</title>
    <link rel="stylesheet" href="users.css">
</head>

<body>
<section id="homebg">
        <nav class="navbar">
            <div class="navbar-container">
                <a href="#" class="navbar-brand">
                    <img src="Frame 6.png" alt="PharmaEase Logo">
                    <span>User</span> </a>
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a href="home.php" class="nav-link">Home</a>
                    </li>
                    <li class="nav-item">
                        <a href="cart.php" class="nav-link">Cart</a>
                    </li>
                    <li class="nav-item">
                        <a href="users.php" class="nav-link">User</a>
                    </li>
                    <li class="nav-item">
                        <a href="index.php" class="nav-link">Logout</a>
                    </li>
                </ul>
            </div>
        </nav>

        <section id="whitespace">
            <br><br><br><br><br><br><br><br>
            <br><br><br><br><br><br><br><br>
        </section>

    </section>
        

        <section id="profile-section">
    <form action="edit.php" method="POST">
    <h2>Profile</h2>
        <div class="form-container">
            <div class="form-group">
                <label for="first_name">First Name</label>
                <input type="text" id="first_name" name="first_name" value="<?php echo $user['first_name']; ?>" readonly>
            </div>
            <div class="form-group">
                <label for="last_name">Last Name</label>
                <input type="text" id="last_name" name="last_name" value="<?php echo $user['last_name']; ?>" readonly>
            </div>
            <div class="form-group">
                <label for="phone">Phone Number</label>
                <input type="text" id="phone" name="phone" value="<?php echo $user['phone']; ?>" readonly>
            </div>
            <div class="form-group">
                <label for="email">Email Address</label>
                <input type="email" id="email" name="email" value="<?php echo $user['email']; ?>" readonly>
            </div>
            <div class="form-group">
                <label for="address">Address</label>
                <input type="text" id="address" name="address" value="<?php echo $user['address']; ?>" readonly>
            </div>
            <div class="form-group">
                <label for="city">City</label>
                <input type="text" id="city" name="city" value="<?php echo $user['city']; ?>" readonly>
            </div>
            <button type="submit" class="btn btn-update">Update Profile</button> </div>

        <div class="button-group">
            <button type="button" class="btn btn-history" id="history">History</button>
        </div>
    </form> 
</section>
	
	<script>
document.getElementById('history').addEventListener('click', function() {
    window.location.href = 'history.php';
});
</script>
	
</body>

</html>