<?php
class User
{
    private $DB_SERVER = 'localhost';
    private $DB_USERNAME = 's2300379_g5pharmaease';
    private $DB_PASSWORD = '12345';
    private $DB_DATABASE = 's2300379_g5pharmaease';
    private $conn;
    public function __construct()
    {
        $this->conn = new mysqli($this->DB_SERVER, $this->DB_USERNAME, $this->DB_PASSWORD, $this->DB_DATABASE);
        if ($this->conn->connect_error) {
            die("Connection failed: " . $this->conn->connect_error);
        }
    }
    public function getConnection()
    {
        return $this->conn;
    }
    public function getAllUsers()
    {
        $sql = "SELECT * FROM user_records";
        $result = $this->conn->query($sql);
        return $result;
    }

    public function getUsersPerGender($gender)
    {
        $sql = "SELECT count(ID) FROM user_records WHERE gender = ?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param("s", $gender);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_row()[0];
    }

    public function getUsersPerStatus($status)
    {
        $sql = "SELECT count(ID) FROM user_records WHERE status = ?";
        $stmt = $this->conn->prepare($sql);
        $stmt->bind_param("s", $status);
        $stmt->execute();
        $result = $stmt->get_result();
        return $result->fetch_row()[0];
    }

    public function authenticateUser($email, $password, $role)
    {
        $table = ($role === 'Admin') ? 'admin_records' : 'user_records';
        $query = "SELECT id, password FROM $table WHERE email = ?";
        $stmt = $this->conn->prepare($query);
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($id, $dbPassword);

        $result = ['success' => false];
        if ($stmt->num_rows > 0) {
            $stmt->fetch();
            if ($password === $dbPassword) {
                $result = ['success' => true, 'id' => $id, 'role' => $role];
            }
        }

        $stmt->close();
        return $result;
    }

    function getPDFUsers()
    {
        $conn = new mysqli($this->DB_SERVER, $this->DB_USERNAME, $this->DB_PASSWORD, $this->DB_DATABASE);

        $query = "SELECT ID, Name, Email, Gender, Status FROM user_records";
        $result = $conn->query($query);

        $users = [];
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $users[] = $row;
            }
        }

        $conn->close();
        return $users;
    }
    public function closeConnection()
    {
        if ($this->conn) {
            $this->conn->close();
        }
    }
    public function getAllUsersWithLimit($limit, $offset, $searchTerm = '')
    {
        $query = "SELECT * FROM user_records";

        if (!empty($searchTerm)) {
            $searchTerm = $this->conn->real_escape_string($searchTerm);
            $query .= " WHERE Name LIKE '%$searchTerm%' 
                       OR Email LIKE '%$searchTerm%' 
                       OR ID LIKE '$searchTerm'";
        }

        $query .= " LIMIT $limit OFFSET $offset";

        $result = $this->conn->query($query);
        return $result;
    }

    public function getTotalUserCount($searchTerm = '')
    {
        $query = "SELECT COUNT(*) as total FROM user_records";

        if (!empty($searchTerm)) {
            $searchTerm = $this->conn->real_escape_string($searchTerm);
            $query .= " WHERE Name LIKE '%$searchTerm%' 
                       OR Email LIKE '%$searchTerm%' 
                       OR ID LIKE '$searchTerm'";
        }

        $result = $this->conn->query($query);
        return $result->fetch_assoc()['total'];
    }
    public function new_user($Name, $Email, $Password, $Status, $Gender)
    {
        $data = [
            [$Name, $Email, $Password, $Status, $Gender],
        ];
        $stmt = $this->conn->prepare("INSERT INTO user_records (Name, Email, Password, Status, Gender) VALUES (?,?,?,?,?)");
        try {
            foreach ($data as $row) {
                $stmt->execute($row);
            }
            $this->conn->commit();
        } catch (Exception $e) {
            $this->conn->rollback();
            throw $e;
        }
        return true;
    }

    // Get all queue entries
    public function getAllQueues() {
        $sql = "SELECT ID, `Queue #`, Name, Email FROM queue ORDER BY `Queue #` ASC";
        return $this->conn->query($sql);
    }

    // Get current queue number
    public function getCurrentQueue() {
        $sql = "SELECT MIN(`Queue #`) as current_queue FROM queue";
        $result = $this->conn->query($sql);
        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            return intval($row['current_queue'] ?? 0);
        }
        return 0;
    }

    // Delete the current queue (lowest number)
    public function deleteCurrentQueue() {
        $currentQueue = $this->getCurrentQueue();
        if ($currentQueue <= 0) {
            return false;
        }
        $sql = "DELETE FROM queue WHERE `Queue #` = ? LIMIT 1";
        $stmt = $this->conn->prepare($sql);
        if (!$stmt) return false;
        $stmt->bind_param("i", $currentQueue);
        return $stmt->execute();
    }

    // Get queue debug info
    public function getQueueDebugInfo() {
        $currentQueue = $this->getCurrentQueue();
        $queueCount = 0;
        $sql = "SELECT COUNT(*) as count FROM queue";
        $result = $this->conn->query($sql);
        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $queueCount = $row['count'];
        }
        $sql = "SHOW TABLES LIKE 'queue'";
        $tableExists = ($this->conn->query($sql)->num_rows > 0);
        $tableStructure = [];
        if ($tableExists) {
            $sql = "DESCRIBE queue";
            $result = $this->conn->query($sql);
            while ($row = $result->fetch_assoc()) {
                $tableStructure[] = $row;
            }
        }
        return [
            'current_queue' => $currentQueue,
            'queue_count' => $queueCount,
            'table_exists' => $tableExists,
            'table_structure' => $tableStructure,
            'connection_error' => $this->conn->error,
            'php_version' => phpversion()
        ];
    }
}