<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once 'QueueController.php';

try {
    $controller = new QueueController();
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
        $action = $_POST['action'];
        $result = $controller->handleQueueUpdate();
        
        header('Content-Type: application/json');
        echo json_encode($result);
    } else {
        header('Content-Type: application/json');
        echo json_encode(["success" => false, "message" => "Invalid request method or missing action"]);
    }
} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode([
        "success" => false, 
        "message" => "Exception: " . $e->getMessage(),
        "file" => $e->getFile(),
        "line" => $e->getLine()
    ]);
}
?> 