<?php
// This view expects $userData array to be passed from the controller
// For MVC adherence, no direct DB or session calls here
?>

<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title>Update Profile - PharmaEase</title>
        <link rel="stylesheet" href="profile.css" />
    </head>

     <body>
     <section id="homebg">
        <nav class="navbar">
            <div class="navbar-container">
            <a href="#" class="navbar-brand">
                <img src="Frame 6.png" alt="PharmaEase Logo" />
                <span>User</span>
                </a>

                <ul class="navbar-nav">
                    <li class="nav-item">
                    <a href="home.php" class="nav-link">Home</a>
                    </li>
                    <li class="nav-item">
                    <a href="cart.php" class="nav-link">Cart</a>
                    </li>
                    <li class="nav-item">
                    <a href="profile.php" class="nav-link">Profile</a>
                    </li>
                    <li class="nav-item">
                    <a href="index.php" class="nav-link">Logout</a>
                    </li>
                </ul>

            </div>

        </nav>

        <section id="whitespace">
            <br /><br /><br /><br /><br /><br /><br /><br />
            <br /><br /><br /><br /><br /><br /><br /><br />
        </section>

        </section>

        <section id="profile-section">

        <h2>Update Profile</h2>

        <?php session_start();
        if (!empty($_SESSION['errorMessage'])) : ?>
        <p style="color:red;"><?php echo htmlspecialchars($_SESSION['errorMessage']); unset($_SESSION['errorMessage']); ?></p>
        <?php endif; ?>
        <?php if (!empty($_SESSION['successMessage'])) : ?>
        <p style="color:green;"><?php echo htmlspecialchars($_SESSION['successMessage']); unset($_SESSION['successMessage']); ?></p>
        <?php endif; ?>
        <form action="../../controller/process.php?action=update_profile" method="POST">

            <div class="form-container">
                <div class="form-group">
                <label for="Name">Name</label>
                <input type="text" id="Name" name="Name" value="<?php echo htmlspecialchars($userData['Name'] ?? ''); ?>" required />
                </div>

                <div class="form-group">
                <label for="Email">Email Address</label>
                <input type="email" id="Email" name="Email" value="<?php echo htmlspecialchars($userData['Email'] ?? ''); ?>" required />
                </div>
                
                <div class="form-group">
                <label for="Password">Password</label>
                <input type="password" id="Password" name="Password" value="<?php echo htmlspecialchars($userData['Password'] ?? ''); ?>" required />
                </div>

                <div class="form-group">
                <label for="Gender">Gender</label>
                <select id="Gender" name="Gender" required>
                        <option value="">Select Gender</option>
                        <option value="male" <?php echo (isset($userData['Gender']) && strtolower($userData['Gender']) === 'male') ? 'selected' : ''; ?>>Male</option>
                        <option value="female" <?php echo (isset($userData['Gender']) && strtolower($userData['Gender']) === 'female') ? 'selected' : ''; ?>>Female</option>
                        <option value="others" <?php echo (isset($userData['Gender']) && strtolower($userData['Gender']) === 'others') ? 'selected' : ''; ?>>Others</option>
                </select>
                </div>

                <div class="form-group">
                <label for="Status">Status</label>
                <select id="Status" name="Status" required>
                        <option value="">Select Status</option>
                        <option value="Regular" <?php echo (isset($userData['Status']) && $userData['Status'] === 'Regular') ? 'selected' : ''; ?>>Regular</option>
                        <option value="PWD" <?php echo (isset($userData['Status']) && $userData['Status'] === 'PWD') ? 'selected' : ''; ?>>PWD</option>
                </select>   
                </div>
                 
            </div>
            <button type="submit" class="btn btn-update">Save</button> 
            </form>
        </section>
</body>

</html>
