<?php
session_start();
require_once '../../model/users.php'; // For getUserData()

// Redirect if user is not logged in
if (!isset($_SESSION['user_email'])) {
    header("Location: index.php"); 
    exit();
}

// Fetch current user data for form pre-filling using getUserData()
// getUserData() is in model/users.php and uses the session email
$fullUserData = getUserData(); 
$full_name = $fullUserData['full_name'];
$phone = $fullUserData['phone'];
$email = $fullUserData['email'];
$address = $fullUserData['address'];
$city = $fullUserData['city'];
$gender = $fullUserData['gender']; // Fetch gender for pre-filling

// Get and clear any profile update messages from the session
$profileMessage = null;
if (isset($_SESSION['profile_message'])) {
    $profileMessage = $_SESSION['profile_message'];
    unset($_SESSION['profile_message']);
}

// Note: The User model connection is not opened/closed here as this page is now for display.
// Connection handling is done in the controller (profile_controller.php) and model methods.
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Update Profile - PharmaEase</title>
    <link rel="stylesheet" href="css/update_profile_styles.css">
</head>
<body>

<section id="profile-section">
    <form action="../../controller/profile_controller.php?action=update_profile" method="POST">
        <h2>Edit Profile</h2>

        <?php if ($profileMessage): ?>
            <p style="color: <?php echo ($profileMessage['type'] === 'success' ? 'green' : 'red'); ?>;">
                <?php echo htmlspecialchars($profileMessage['text']); ?>
            </p>
        <?php endif; ?>

        <div class="form-container">
            <div class="form-group">
                <label for="full_name">Full Name</label>
                <input type="text" name="full_name" id="full_name" value="<?php echo htmlspecialchars($full_name); ?>" required>
            </div>
            <div class="form-group">
                <label for="phone">Phone Number</label>
                <input type="text" name="phone" id="phone" value="<?php echo htmlspecialchars($phone); ?>" required>
            </div>
            <div class="form-group">
                <label for="email">Email Address</label>
                <input type="email" name="email" id="email" value="<?php echo htmlspecialchars($email); ?>" required>
            </div>
            <div class="form-group">
                <label for="gender">Gender</label>
                <select name="gender" id="gender" required>
                    <option value="" <?php echo empty($gender) ? 'selected' : ''; ?>>Select Gender</option>
                    <option value="Male" <?php echo ($gender === 'Male') ? 'selected' : ''; ?>>Male</option>
                    <option value="Female" <?php echo ($gender === 'Female') ? 'selected' : ''; ?>>Female</option>
                    <option value="Other" <?php echo ($gender === 'Other') ? 'selected' : ''; ?>>Other</option>
                </select>
            </div>
            <div class="form-group">
                <label for="address">Address</label>
                <input type="text" name="address" id="address" value="<?php echo htmlspecialchars($address); ?>" required>
            </div>
            <div class="form-group">
                <label for="city">City</label>
                <input type="text" name="city" id="city" value="<?php echo htmlspecialchars($city); ?>" required>
            </div>
          <div class="button-group">
              <button type="submit" class="btn btn-update">Save Changes</button>
              <a href="users.php" class="btn btn-secondary">Back to Profile</a>
          </div>
        </div>
    </form>
</section>

</body>
</html>
