<?php
session_start();
if (!isset($_SESSION['user_email'])) {
    header("Location: index.php");
    exit();
}

// Include the model to access database functions
require_once '../../model/users.php';

$userId = $_SESSION['user_id'] ?? 0;

// Process remove item from cart
if (isset($_POST['remove_item']) && isset($_POST['item_id'])) {
    $itemId = intval($_POST['item_id']);
    $userModel = new User();
    $userModel->removeCartItem($userId, $itemId);
    // Redirect to refresh page and avoid form resubmission
    header("Location: cart.php");
    exit();
}

// Get active cart from database
$userModel = new User();
$cartItems = $userModel->getActiveCart($userId);
$total = 0;

// Calculate total
if (!empty($cartItems)) {
    foreach ($cartItems as $item) {
        $total += $item['price'] * $item['quantity'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PharmaEase</title>
    <link rel="stylesheet" href="navbar_styles.css">
    <link rel="stylesheet" href="cart.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Days+One&family=Lexend:wght@100..900&family=Teko:wght@300..700&display=swap');
        
        .cart-item {
            margin-bottom: 15px;
            padding: 15px;
            border: 1px solid #ccc;
            border-radius: 8px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            max-width: 600px;
            background-color: white;
        }
        
        .cart-item-info {
            flex-grow: 1;
        }
        
        .remove-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 5px;
            cursor: pointer;
        }
        
        .cart-total {
            margin-top: 20px;
            font-weight: bold;
            font-size: 18px;
        }
        
        .button-group {
            margin-top: 20px;
            display: flex;
            gap: 10px;
        }
        
        .checkout-btn, .history-btn {
            padding: 10px 20px;
            background-color: #4a7c8a;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
            text-decoration: none;
        }
        
        .checkout-btn:hover, .history-btn:hover {
            background-color: #3a6b76;
        }
        
        .empty-cart {
            margin-top: 30px;
            color: #666;
            font-style: italic;
        }
    </style>
</head>

<body>
    <section id="homebg">
        <nav class="navbar">
            <div class="navbar-container">
                <a href="home.php" class="navbar-brand">
                    <img src="Frame 6.png" alt="PharmaEase Logo">
                    <span>PharmaEase</span> </a>
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a href="home.php" class="nav-link">Home</a>
                    </li>
                    <li class="nav-item">
                        <a href="cart.php" class="nav-link">Cart</a>
                    </li>
                    <li class="nav-item">
                        <a href="users.php" class="nav-link">User</a>
                    </li>
                    <li class="nav-item">
                        <a href="../../controller/logout.php" class="nav-link">Logout</a>
                    </li>
                </ul>
            </div>
        </nav>
        <section id="welcome">
            <h1>Welcome to PharmaEase <br>
                A service you can trust</h1>
        </section>
        <section id="whitespace">
            <br><br><br><br><br><br><br><br>
        </section>
    </section>

    <section id="mycart">
        <h1>My Cart</h1>
        
        <?php if (empty($cartItems)): ?>
            <div class="empty-cart">Your cart is empty.</div><br>
            <a href="history.php" class="history-btn">Check History</a>
        <?php else: ?>
            <?php foreach ($cartItems as $item): ?>
                <div class="cart-item">
                    <div class="cart-item-info">
                        <?php echo htmlspecialchars($item['name']); ?> - 
                        ₱<?php echo number_format($item['price'], 2); ?> x 
                        <?php echo $item['quantity']; ?>
                    </div>
                    <form method="post" action="cart.php">
                        <input type="hidden" name="item_id" value="<?php echo $item['product_id']; ?>">
                        <button type="submit" name="remove_item" class="remove-btn">Remove</button>
                    </form>
                </div>
            <?php endforeach; ?>
            
            <div class="cart-total">
                Total: ₱<?php echo number_format($total, 2); ?>
            </div>
            
            <div class="button-group">
                <form method="post" action="../../controller/handle_checkout.php">
                    <button type="submit" name="checkout" class="checkout-btn">Checkout</button>
                </form>
                
                <a href="history.php" class="history-btn">Check History</a>
            </div>
        <?php endif; ?>
    </section>
</body>
</html>