<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Check if the admin is logged in, otherwise redirect to login page
if (!isset($_SESSION['admin_email'])) {
    header("Location: ../user/index.php");
    exit();
}

// Prevent caching of this page
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Pragma: no-cache");

require_once '../../model/users.php'; // Contains User class with product methods

$userModel = new User();
$productsResult = $userModel->getAllProducts();

// You might want to display messages from session (e.g., after add/edit/delete)
$successMessage = $_SESSION['product_success_message'] ?? null;
$errorMessage = $_SESSION['product_error_message'] ?? null;
unset($_SESSION['product_success_message'], $_SESSION['product_error_message']);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Products</title>
    <!-- Link to a shared admin CSS or create a new one -->
    <link rel="stylesheet" href="dashboard.css">
    <link rel="stylesheet" href="manage_products_styles.css">
    <link rel="stylesheet" href="../user/navbar_styles.css">
</head>
<body>
    <nav class="navbar">
        <div class="navbar-container">
            <a href="#" class="navbar-brand"><img src="logo.png" alt="PharmaEase Logo"><span>PharmaEase</span></a>
            <ul class="navbar-nav">
                <li class="nav-item"><a href="home.php" class="nav-link">Home</a></li>
                <li class="nav-item"><a href="dashboard.php" class="nav-link">Dashboard</a></li>
                <li class="nav-item"><a href="manage_products.php" class="nav-link">Products</a></li>
                <li class="nav-item"><a href="../../controller/logout.php" class="nav-link">Logout</a></li>
            </ul>
        </div>
    </nav>

    <div class="container">
        <h1>Manage Products</h1>

        <?php if ($successMessage): ?>
            <div class="message success"><?php echo htmlspecialchars($successMessage); ?></div>
        <?php endif; ?>
        <?php if ($errorMessage): ?>
            <div class="message error"><?php echo htmlspecialchars($errorMessage); ?></div>
        <?php endif; ?>

        <a href="add_product.php" class="add-btn">Add New Product</a>

        <table>
            <thead>
                <tr>
                    <th>Product ID</th>
                    <th>Name</th>
                    <th>Price</th>
                    <th>Description</th>
                    <th>Stock</th>
                    <th>Admin ID</th>
                    <th>Image Path</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($productsResult && $productsResult->num_rows > 0) {
                    while ($product = $productsResult->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($product['product_id']) . "</td>";
                        echo "<td>" . htmlspecialchars($product['name']) . "</td>";
                        echo "<td>₱" . htmlspecialchars(number_format((float)$product['price'], 2)) . "</td>";
                        echo "<td>" . htmlspecialchars(substr($product['description'], 0, 100)) . (strlen($product['description']) > 100 ? '...' : '') . "</td>";
                        echo "<td>" . htmlspecialchars($product['stock']) . "</td>";
                        echo "<td>" . htmlspecialchars($product['admin_id']) . "</td>";
                        echo "<td>" . htmlspecialchars($product['image_path'] ?? 'N/A') . "</td>";
                        echo "<td class='action-buttons'>";
                        echo '<a href="edit_product.php?id=' . $product['product_id'] . '" class="edit-btn">Edit</a>';
                        echo '<a href="../../controller/delete_product_controller.php?id=' . $product['product_id'] . '" class="delete-btn" onclick="return confirm(\'Are you sure you want to delete this product?\')">Delete</a>';
                        echo "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='8'>No products found.</td></tr>";
                }
                $userModel->closeConnection();
                ?>
            </tbody>
        </table>
    </div>
</body>
</html> 