<?php
if (session_status() == PHP_SESSION_NONE) { // Ensure session is started first
    session_start();
}

// Include model to interact with database
require_once __DIR__ . '/../../model/users.php';

// Don't require admin role - this page can be accessed by both users and admins
$isAdmin = isset($_SESSION['role']) && $_SESSION['role'] === 'Admin';

// Get order ID from URL parameter
$orderId = isset($_GET['order_id']) ? $_GET['order_id'] : null;

if (!$orderId) {
    // Redirect based on user role
    if ($isAdmin) {
        header("Location: home.php");
    } else {
        header("Location: ../user/cart.php?error=no_order_found");
    }
    exit();
}

// Create model instance and fetch order details from database
$userModel = new User();
$orderDetails = $userModel->getOrderDetailsById($orderId);

// If order not found, redirect
if (!$orderDetails) {
    $userModel->closeConnection();
    if ($isAdmin) {
        header("Location: home.php");
    } else {
        header("Location: ../user/cart.php?error=invalid_order");
    }
    exit();
}

// Get queue number and user name from database result
$queueNumber = isset($orderDetails['queue_number']) ? $orderDetails['queue_number'] : 'N/A';
$userName = isset($orderDetails['full_name']) ? $orderDetails['full_name'] : 'Customer';

$userModel->closeConnection();

// Choose the correct navigation based on user role
$navbarHtml = '';
if ($isAdmin) {
    $navbarHtml = '
    <nav class="navbar">
        <div class="navbar-container">
            <a href="#" class="navbar-brand">
                <img src="logo.png" alt="PharmaEase Logo">
                <span>PharmaEase</span> </a>
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a href="../user/home.php" class="nav-link">Home</a>
                </li>
                <li class="nav-item">
                    <a href="dashboard.php" class="nav-link">Dashboard</a>
                </li>
                <li class="nav-item">
                    <a href="user-profile.php" class="nav-link">Profile</a>
                </li>
                <li class="nav-item">
                    <a href="../../controller/logout.php" class="nav-link">Logout</a>
                </li>
            </ul>
        </div>
    </nav>';
} else {
    $navbarHtml = ''; // No navbar for users, or customize as needed
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Queue Number - PharmaEase</title>
    <link rel="stylesheet" href="generate.css">
    <link href='https://fonts.googleapis.com/css?family=Ramabhadra' rel='stylesheet'>
</head>
<body>
<?php echo $navbarHtml; ?>
<div class="card">
    <img src="logo.png" class="pharmacy-icon" alt="Pharmacy Logo">
    <div class="number">#<?php echo sprintf('%03d', $queueNumber); ?></div>
    <div class="name"><?php echo htmlspecialchars($userName); ?></div>
    <div class="button-container">
        <a href="../../controller/generateOrderPDF.php?order_id=<?php echo $orderId; ?>" class="button view-pdf" target="_blank">View PDF</a>
        <?php if ($isAdmin): ?>
        <?php else: ?>
            <a href="../user/home.php" class="button home">Home</a>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
