<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Include the User model
require_once '../model/users.php';

// Set header to return JSON
header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'User not logged in']);
    exit;
}

$userId = $_SESSION['user_id'];

// Process add to cart request
if (isset($_POST['add_to_cart']) && isset($_POST['product_id'])) {
    $productId = intval($_POST['product_id']);
    $quantity = isset($_POST['quantity']) ? intval($_POST['quantity']) : 1;
    
    // Validate input
    if ($productId <= 0 || $quantity <= 0) {
        echo json_encode(['success' => false, 'message' => 'Invalid product ID or quantity']);
        exit;
    }
    
    $userModel = new User();
    
    // Check if product exists and is in stock
    $product = $userModel->getProductById($productId);
    if (!$product) {
        echo json_encode(['success' => false, 'message' => 'Product not found']);
        exit;
    }
    
    // Check stock - optional depending on business rules
    if (isset($product['stock']) && $product['stock'] < $quantity) {
        echo json_encode(['success' => false, 'message' => 'Not enough stock available']);
        exit;
    }
    
    // Add to cart
    $result = $userModel->addToCart($userId, $productId, $quantity);
    
    // Close the database connection
    $userModel->closeConnection();
    
    if ($result) {
        echo json_encode(['success' => true, 'message' => 'Product added to cart']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to add product to cart']);
    }
    exit;
}

// Remove from cart
if (isset($_POST['remove_from_cart']) && isset($_POST['product_id'])) {
    $productId = intval($_POST['product_id']);
    
    $userModel = new User();
    $result = $userModel->removeCartItem($userId, $productId);
    $userModel->closeConnection();
    
    if ($result) {
        echo json_encode(['success' => true, 'message' => 'Product removed from cart']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to remove product from cart']);
    }
    exit;
}

// Update quantity in cart
if (isset($_POST['update_quantity']) && isset($_POST['product_id']) && isset($_POST['quantity'])) {
    $productId = intval($_POST['product_id']);
    $quantity = intval($_POST['quantity']);
    
    if ($quantity <= 0) {
        // If quantity is 0 or negative, remove the item
        $userModel = new User();
        $result = $userModel->removeCartItem($userId, $productId);
        $userModel->closeConnection();
        
        if ($result) {
            echo json_encode(['success' => true, 'message' => 'Product removed from cart']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to remove product from cart']);
        }
    } else {
        // Otherwise, first remove it then add with new quantity
        $userModel = new User();
        $userModel->removeCartItem($userId, $productId);
        $result = $userModel->addToCart($userId, $productId, $quantity);
        $userModel->closeConnection();
        
        if ($result) {
            echo json_encode(['success' => true, 'message' => 'Quantity updated']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to update quantity']);
        }
    }
    exit;
}

// If no valid action was provided
echo json_encode(['success' => false, 'message' => 'No valid action specified']);
?> 