<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Check if user is admin, redirect to user login if not or if role not set
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Admin') {
    header("Location: ../view/user/index.php"); 
    exit();
}

require_once '../../model/users.php';

$message = '';

if (isset($_GET['id'])) {
    $userId = (int)$_GET['id'];
    
    if ($userId > 0) {
        $userModel = new User();
        if ($userModel->deleteUserById($userId)) {
            // Successfully deleted
            $_SESSION['delete_message'] = 'User deleted successfully.'; // Optional: use session for success message
        } else {
            // Deletion failed
            $_SESSION['delete_error'] = 'Error: Could not delete user.'; // Optional: use session for error message
        }
        $userModel->closeConnection();
    } else {
        $_SESSION['delete_error'] = 'Error: Invalid User ID provided.';
    }
} else {
    $_SESSION['delete_error'] = 'Error: User ID not provided.';
}

// Redirect back to the dashboard
header("Location: ../view/admin/dashboard.php");
exit();
?>