<?php
if (session_status() == PHP_SESSION_NONE) { // Ensure session is started first
    session_start();
}

// Check if user is admin, redirect to user login if not or if role not set
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Admin') {
    header("Location: ../user/index.php"); 
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pharmacy Receipt</title>
    <link rel="stylesheet" href="order.css">
    <link href='https://fonts.googleapis.com/css?family=Ramabhadra' rel='stylesheet'>
</head>
<body>
<nav class="navbar">
                <div class="navbar-container">
                    <a href="#" class="navbar-brand">
                        <img src="logo.png" alt="PharmaEase Logo">
                        <span>PharmaEase</span> </a>
                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <a href="home.php" class="nav-link">Home</a>
                        </li>
                        <li class="nav-item">
                            <a href="dashboard.php" class="nav-link">Dashboard</a>
                        </li>
                        <li class="nav-item">
                            <a href="user-profile.php" class="nav-link">Profile</a>
                        </li>
                        <li class="nav-item">
                            <a href="../../controller/logout.php" class="nav-link">Logout</a>
                        </li>
                    </ul>
                </div>
</nav>
<div class="receipt">
        <div class="header">
            <div class="customer-info">
                <h2>Margrethe Gilpo</h2>
                <p class="email">mg@gmail.com</p>
            </div>
            <div class="order-number">#001</div>
        </div>

        <div class="order-items">
            <div class="item">
                <span class="col-number">1.</span>
                <span class="col-name">Paracetamol Biogesic (Per Piece)</span>
                <span class="col-quantity">2x</span>
                <span class="col-price">₱14.00</span>
            </div>

            <div class="item">
                <span class="col-number">2.</span>
                <span class="col-name">Celebrex (Per Box)</span>
                <span class="col-quantity">1x</span>
                <span class="col-price">₱120.00</span>
            </div>

            <div class="item">
                <span class="col-number">3.</span>
                <span class="col-name">Bioflu (Per Piece)</span>
                <span class="col-quantity">7x</span>
                <span class="col-price">₱45.00</span>
            </div>
        </div>

        <div class="total">
            <h3>TOTAL: ₱179.00</h3>
        </div>

        <div class="logo">
            <img src="logo.png" alt="Pharmacy Logo">
        </div>
    </div>
</body>
</html>
