<?php
require_once __DIR__ . '/../model/users.php';

class QueueController {
    private $user;

    public function __construct() {
        $this->user = new User();
    }

    public function getAllQueues() {
        return $this->user->getAllQueues();
    }

    public function getCurrentQueue() {
        return $this->user->getCurrentQueue();
    }

    public function updateQueue($action) {
        if ($action === 'increase') {
            $success = $this->user->deleteCurrentQueue();
            if ($success) {
                return ["success" => true, "message" => "Queue updated successfully"];
            } else {
                return ["success" => false, "message" => "No records in queue to update"];
            }
        } else {
            return ["success" => false, "message" => "Unsupported action: " . $action];
        }
    }

    public function handleQueueUpdate() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
            $action = $_POST['action'];
            return $this->updateQueue($action);
        } else {
            return ["success" => false, "message" => "Invalid request or missing action parameter"];
        }
    }

    public function debug() {
        return $this->user->getQueueDebugInfo();
    }
}
?> 