<?php
if (session_status() == PHP_SESSION_NONE) { // Ensure session is started first
    session_start();
}

// Check if user is admin, redirect to user login if not or if role not set
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'Admin') {
    header("Location: ../user/index.php"); 
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generate Queue Display</title>
    <link rel="stylesheet" href="generate.css">
    <link href='https://fonts.googleapis.com/css?family=Ramabhadra' rel='stylesheet'>
    </head>
<body>
<nav class="navbar">
                <div class="navbar-container">
                    <a href="#" class="navbar-brand">
                        <img src="logo.png" alt="PharmaEase Logo">
                        <span>PharmaEase</span> </a>
                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <a href="home.php" class="nav-link">Home</a>
                        </li>
                        <li class="nav-item">
                            <a href="dashboard.php" class="nav-link">Dashboard</a>
                        </li>
                        <li class="nav-item">
                            <a href="user-profile.php" class="nav-link">Profile</a>
                        </li>
                        <li class="nav-item">
                            <a href="../../controller/logout.php" class="nav-link">Logout</a>
                        </li>
                    </ul>
                </div>
</nav>
<div class="card">
    <img src="logo.png" class="pharmacy-icon" alt="Pharmacy Logo">
    <div class="number">#001</div>
    <div class="name">Margrethe Gilpo</div>
    <div class="button-container">
        <a class="button view-pdf">View Pdf</a>
        <a href = "order.php" class="button home">View Order</a>
        <a class="button remove">Remove from Queue</a>
    </div>
</div>
