<?php
require_once '../../controller/process.php'; // Changed from ../controller/

// Get user ID from URL
$userId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Initialize processor
$processor = new UserProcessor();
$user = $processor->getUserById($userId);

if (!$user) {
    header('Location: dashboard.php'); // Stays dashboard.php (now relative to view/admin/)
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit User</title>
    <link rel="stylesheet" href="edit.css"> <!-- Changed from href="edit.css" (was relative to model/) -->
</head>
<body>
    <div class="container">
        <h1>Edit User</h1>
        
        <div id="form-block">
            <form method="POST" action="../../controller/process.php?action=update"> <!-- Changed from ../controller/ -->
                <input type="hidden" name="id" value="<?= htmlspecialchars($user['ID']) ?>">
                
                <div id="form-block-half">
                    <label for="Name">Name</label>
                    <input type="text" id="Name" name="Name" value="<?= htmlspecialchars($user['Name']) ?>" required>
                    
                    <label for="Email">Email</label>
                    <input type="email" id="Email" name="Email" value="<?= htmlspecialchars($user['Email']) ?>" required>
                </div>
                
                <div id="form-block-half">
                    <label for="Gender">Gender</label>
                    <select id="Gender" name="Gender" required>
                        <option value="Male" <?= $user['Gender'] == 'Male' ? 'selected' : '' ?>>Male</option>
                        <option value="Female" <?= $user['Gender'] == 'Female' ? 'selected' : '' ?>>Female</option>
                        <option value="Others" <?= $user['Gender'] == 'Others' ? 'selected' : '' ?>>Others</option>
                    </select>
                    
                    <label for="Status">Status</label>
                    <select id="Status" name="Status" required>
                        <option value="Regular" <?= $user['Status'] == 'Regular' ? 'selected' : '' ?>>Regular</option>
                        <option value="PWD" <?= $user['Status'] == 'PWD' ? 'selected' : '' ?>>PWD</option>
                    </select>
                </div>
                
                <div id="button-block">
                    <input type="submit" value="Update">
                    <a href="dashboard.php" class="cancel-btn">Cancel</a> <!-- Changed from ../view/admin/dashboard.php -->
                </div>
            </form>
        </div>
    </div>
</body>
</html> 